<div class="c-row">
	<?php
			$the_query = new WP_Query( array('posts_per_page'=>12,
			'post_type'=>'post',
			'orderby'    => 'DESC',
			'post_status'    => 'publish',
			'paged' => get_query_var('paged') ? get_query_var('paged') : 1) 
			); 
	?>
	<?php while ($the_query -> have_posts()) : $the_query -> the_post(); 
	$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
	$content = get_the_content();
	$content = strip_tags($content);
	$category_detail=get_the_category($post->ID);
	foreach($category_detail as $cd){
	$cat_name = $cd->cat_name;
	}
	$post_date = get_the_date( 'F j, Y' );
	?>
	<div class="c-col">
		<article class="c-article">
			<div class="c-row">
				<div class="c-tag-col"><span class="c-tag"><?php echo $cat_name;?></span></div>
				<div class="c-date-col"><span class="c-date"><?php echo $post_date;?></span></div>
			</div>
			
			<a href="<?php the_permalink(); ?>" class="c-img">
				<img src="<?php echo $image[0]; ?>" alt="">
			</a>
			<div class="c-article-details">
				<h3><a href="<?php the_permalink(); ?>"><?php echo get_the_title(); ?></a></h3>
				<?php if($content !=''){ ?>
				<p><?php echo substr($content, 0, 100);?>...</p>
				<?php } ?>
				<a href="<?php the_permalink(); ?>" class="c-btn">Read More</a>
			</div>
		</article>
	</div>
	<?php
	endwhile;
?>
</div>
<div class="pagination-outer">
<?php
	$big = 999999999; // need an unlikely integer
	echo paginate_links( array(
	'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
	'format' => '?paged=%#%',
	'current' => max( 1, get_query_var('paged') ),
	'total' => $the_query->max_num_pages
	) );

	wp_reset_postdata();
	?>
	
</div>
<script>
		jQuery(document).ready(function() {
			
			jQuery('.prev.page-numbers').text('«');
			jQuery('.next.page-numbers').text('»');
			
		});
			
</script>
<style>
.c-row {
    display: flex;
   flex-wrap: wrap;
   justify-content: space-between;
}
.c-col {
    width: calc(33.33% - 30px);
    padding: 0 0 30px;
}
.c-tag {
    background: #ED1C2419 !important;
    padding: 5px 15px;
    display: inline-block;
    border-radius: 25px !important;
    font-size: 12px;
    color: #000 !important;
    font-weight: 600;
}
.c-tag-col {
    margin-bottom: 10px;
}
p:empty{
   display: none;
}
.c-date-col {
    font-size: 12px;
    color: #959595 !important;
    font-weight: 400;
    margin-bottom: 10px !important;
    padding: 5px 0;
}
.c-img img {
    margin: 0 !important;
    background-color: #f2f2f2 !important;
    height: 233px !important;
    object-fit: cover;
    width: 100%;
}
.c-img {
    display: flex;
}
.c-article-details h3{
    padding-bottom: 5px !important;
}
.c-article-details h3 a {
    font-size: 22px;
    color: #000 !important;
    display: inline-block;
    font-weight: 600 !important;
}
.c-article-details h3 a:hover {
    color: #ed1c24 !important;
}
.c-article-details p{
   font-size: 14px;
   color: #727272 !important;
   font-weight: 400;
}
.c-btn {
    height: 42px;
    padding: 0 15px !important;
    min-width: 128px;
    background-color: #EBEBEB !important;
    border-radius: 25px !important;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    color: #000 !important;
    font-weight: 600 !important;
    margin-top: 15px !important;
}
.c-article-details {
    padding: 10px 0;
}
.c-btn:hover{
    background-color: #ed1c24 !important;
    color: #fff !important;
}

@media (max-width: 1199px){
     .c-col {
        width: calc(50% - 15px);
    }
}
@media (max-width: 767px){
     .c-col {
        width: 100% ;
    }
}
</style>