<?php ?>

<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Caelius Consulting || Bharat Arora</title>

	<style>

		:root{
			--primary-color: #ec2327;
		}

		body {
			margin: 0;
			font-family: -apple-system, Arial, sans-serif;
		}

		.btn {
			margin: 3px;
			display: inline-flex;
			flex: 1;
			padding: 10px 15px;
			text-decoration: none;
			background: transparent;
			border: 1px solid var(--primary-color);
			border-radius: 3px;
			color: black;
			justify-content: center;
			white-space: nowrap;
		}

		.btn:hover{
			background: var(--primary-color);
			color: white;
		}

		.business-card{
			padding: 40px;
		}

		h1 {
			font-size: 30px;
			margin-block-start: 60px;
			margin-block-end: 0px;
			color: var(--primary-color);
			font-weight: 500;
		}
		h4 {
			font-size: 18px;
			margin-block-start: 10px;
			color: gray;
			font-weight: 500;
		}
		.social-links {
			position: relative;
			padding: 30px 0px;
		}

		.social-links:before{
			content: "";
			position: absolute;
			top: 0;
			left: -40px;
			width: calc(100% + 80px);
			height: 60%;
			background: #ededed;
			z-index: -1;
		}
		.social-links ul {
			padding: 0;
			margin: 0;
			list-style: none;
			display: flex;
			flex-wrap: wrap;
			gap: 10px;
			justify-content: space-between;
		}
		.social-links ul li {
			background: white;
			border-radius: 4px;
			box-shadow: 0 10px 22px -11px rgba(0, 0, 0, 0.3);
			flex: 1;
			text-align: center;
		}

		.social-links ul li a {
			display: flex;
			padding: 10px;
			justify-content: center;
			flex-direction: column;
			text-decoration: none;
			color: rgb(75, 75, 75);
			font-size: 14px;
			align-items: center;
			gap: 10px;
		}
		
		.social-links ul li a img {
			height: 30px;
			width: 40px;
			object-fit: contain;
		}

		.address ul{
			margin: 0;
			padding: 40px 0;
			list-style: none;
		}
		.address ul li h5 {
			margin-block: 0;
		}
		.address ul li p {
			color: grey;
			margin-block-start: 10px;
			font-size: 14px;
			line-height: 22px;
		}

		.share-save {
			display: flex;
			column-gap: 15px;
			flex-wrap: wrap;
		}

	</style>
</head>
<body>
	<section class="business-card">
		<div class="logo">
			<img src="https://www.caeliusconsulting.com/image/logo.svg" alt="logo" width="170" height="40">
		</div>
		<h1>Siddharth Chauhan</h1>
		<h4>Delivery Lead - Integration & Automation</h4>
		<div class="social-links">
			<ul>
				<li>
					<a href="tel:+919988144115">
						<img src="../image/icons/call.png" alt="Call">
						Call
					</a>
				</li>
				<li>
					<a href="mailto:siddharth.chauhan@caeliusconsulting.com">
						<img src="../image/icons/mail.png" alt="Mail">
						Mail
					</a>
				</li>
				<li>
					<a href="https://www.linkedin.com/in/siddharth0541/" target="_blank">
						<img src="../image/icons/linkedin.png" alt="LinkedIn">
						LinkedIn
					</a>
				</li>
				<li>
					<a href="https://caeliusconsulting.com" target="_blank">
						<img src="../image/icons/website.png" alt="Website">
						Website
					</a>
				</li>
			</ul>
		</div>
		<div class="share-save">
			<a target="_blank" href="https://vcard.link/card/D9Hj.vcf" class="btn">Save Contact</a>
			<!-- <a href="javascript:void()" id="copy" class="btn">Share Contact</a> -->
		</div>
		<div class="address">
			<ul>
				<li>
					<h5>USA</h5>
					<p>8501 Wade Blvd. Suite 250. Frisco, TX 75034</p>
				</li>
				<li>
					<h5>Canada</h5>
					<p>6-2557 Dougall Avenue, Suite 200, Windsor, ON N8X 1T5</p>
				</li>
				<li>
					<h5>SINGAPORE</h5>
					<p>Fifth Avenue, #03-08, Guthrie House, Singapore - 268802</p>
				</li>
				<li>
					<h5>India</h5>
					<p>627, 6th Floor, Tower - A, Bestech Business Towers, Sector-66, SAS Nagar (Chandigarh) - 160066</p>
					<p>609, Floor 6th  Gowra Fountain Head, Madhapur, Hyderabad, Rangareddy, Telangana, 500081</p>
				</li>
			</ul>
		</div>
	</section>
</body>
</html>

<?php ?>