<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.4.1/dist/css/bootstrap.min.css" integrity="sha384-Vkoo8x4CGsO3+Hhxv8T/Q5PaXtkKtu6ug5TOeNV6gBiFeWPGFN9MuhOf23Q9Ifjh" crossorigin="anonymous">
</head>
<body class="container mt-5"> 
    <div id="servermsg"></div>
    <form class="w-50 mx-auto" id="login-form">
        <div class="form-group">
            <label>Sales Manager Email ID</label><br/>
            <input id="email" type="email" name="useremail" class="form-control"  />
            <span id="emailmsg" class="text-danger"></span>
        </div>
        <div class="form-group">
            <label>Prospect Name</label><br/>
            <input id="prospectname" type="text" name="userprospect" class="form-control"/>
            <span id="prospectnamemsg" class="text-danger"></span>
        </div>
        <div class="form-group">
            <label>Project Start Date</label><br/>
            <input id="startdate" type="date" name="projectstartdate" class="form-control"/>
            <span id="startdatemsg" class="text-danger"></span>
        </div>
        <div class="form-group">     
            <label >Price</label><br/>
            <input id="price" type="type" name="userprice" class="form-control"/>
            <span id="pricemsg" class="text-danger" ></span>
        </div>  
        <div class="form-group">     
            <label >Discount</label><br/>
            <input id="discount" type="type" name="userdiscount" class="form-control"/>
            <span id="discountmsg" class="text-danger"></span>
        </div>  
        
        <input type="submit" class="btn btn-danger" value="Submit" class="form-control" />
    </form>
</body>
<script src="https://code.jquery.com/jquery-3.3.1.min.js"
    integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous">
</script>
<script>
    //get the form from DOM (Document object model) 
    var form = document.getElementById('login-form');

    form.onsubmit = function(event){

        event.preventDefault();
        var email = document.getElementById('email').value;
        var prospectname = document.getElementById('prospectname').value;
        var d = new Date(document.getElementById('startdate').value); 
        var startdate = d.getDate()  + "-" + (d.getMonth()+1) + "-" + d.getFullYear();
        var price = document.getElementById('price').value;
        var discount = document.getElementById('discount').value;

        document.getElementById('emailmsg').innerHTML="";
        document.getElementById('startdatemsg').innerHTML="";
        document.getElementById('pricemsg').innerHTML="";
        document.getElementById('discountmsg').innerHTML="";

        if(!formValidation(email,prospectname,startdate,price,discount)){
            return;
        }

        var dataSet = { 
            date: startdate, 
            discount: parseFloat(discount), 
            emailId: email, 
            name: prospectname, 
            price:  parseFloat(price)
        }
		
    }
	
	
}

    function formValidation(email,prospectname,startdate,price,discount){

        var isvalid = true;
        if(!email){
            document.getElementById('emailmsg').innerHTML = "Email Id is required";
            isvalid = false;
        } else if (!mailValidation(email)){
            document.getElementById('emailmsg').innerHTML = "Invalid email Id";
            isvalid = false;
        }
        if(!startdate.toString()){
            document.getElementById('startdatemsg').innerHTML = "Start Date is required";
            isvalid = false;
        } 
        if(!price){
            document.getElementById('pricemsg').innerHTML = "price is required";
            isvalid = false;
        } else if(!(price.match(/^\d+\.\d+$/)) && !(price.match(/^-?\d+$/))){
            document.getElementById('pricemsg').innerHTML = "price should be number";
            isvalid = false;
        }
        if(!discount){
            document.getElementById('discountmsg').innerHTML = "discount is required";
            isvalid = false;
        } else if(!(discount.match(/^\d+\.\d+$/)) && !(discount.match(/^-?\d+$/))){
            document.getElementById('discountmsg').innerHTML = "discount should be number";
            isvalid = false;
        }
        
        return isvalid;
    }

    function mailValidation(email){
        if(email.includes('@')){
            var emailArray = email.split("@");
            if(emailArray[1] && ['mulesoft.com','gmail.com'].includes(emailArray[1])){
                return true;
            }
        }
        return false;
    }

</script>


</html>
<?php 
	// post data in api
	
	$application_array=json_encode(dataSet);
	$application_url='http://66.29.155.220:8080/quotation/generate/';
	
	
	
	$application_curl = curl_init();
	curl_setopt($application_curl, CURLOPT_URL, $application_url);
	curl_setopt($application_curl, CURLOPT_POST, 1);
	//send paramerter in api
	if ($application_array) {
		curl_setopt($application_curl, CURLOPT_POSTFIELDS, $application_array);
	}
	curl_setopt($application_curl, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($application_curl, CURLOPT_HTTPHEADER, array(
          'Content-Type: application/json',
       ));
	$application_curl_response = curl_exec($application_curl);
	$json_application_curl = json_decode($application_curl_response, true);
	print_r($json_application_curl);
?>