<?php
// Simple script to check access to mail directory and files
header('Content-Type: text/plain');

echo "Mail Directory Access Check\n";
echo "==========================\n\n";

// Check if mail directory exists
$mailDir = 'mail';
echo "1. Checking if mail directory exists: ";
if (is_dir($mailDir)) {
    echo "YES\n";
} else {
    echo "NO - Directory not found\n";
}

// Check mail-send-career.php path
$targetScript = 'mail/mail-send-career.php';
echo "2. Checking if $targetScript exists: ";
if (file_exists($targetScript)) {
    echo "YES\n";
} else {
    echo "NO - File not found\n";
}

// Check permissions
if (file_exists($targetScript)) {
    echo "3. Checking permissions on $targetScript: ";
    $perms = fileperms($targetScript);
    echo substr(sprintf('%o', $perms), -4) . "\n";
    
    echo "4. Is the file readable: ";
    echo is_readable($targetScript) ? "YES\n" : "NO\n";
}

// Check .htaccess restrictions
$htaccessPath = 'mail/.htaccess';
echo "5. Checking if mail/.htaccess exists: ";
if (file_exists($htaccessPath)) {
    echo "YES - This might be restricting access\n";
    echo "   Content: \n";
    echo file_get_contents($htaccessPath) . "\n";
} else {
    echo "NO\n";
}

// Test including the file
echo "6. Attempting to include the file: ";
try {
    include_once($targetScript);
    echo "SUCCESS (no errors)\n";
} catch (Exception $e) {
    echo "FAILED - " . $e->getMessage() . "\n";
}

// List all files in the mail directory
echo "\n7. Listing all files in mail directory:\n";
if (is_dir($mailDir)) {
    $files = scandir($mailDir);
    foreach ($files as $file) {
        if ($file != '.' && $file != '..') {
            echo "   - $file\n";
        }
    }
} else {
    echo "   Cannot list files - directory not found\n";
}
?> 