<?php
class data
{
    private $conn;
    
    public function __construct($conn=0)
    {
        $this->conn = $conn;
        return $conn;
    }
    
    /**
     * Load environment variables from .env file
     */
    private static function loadEnv() {
        $envFile = __DIR__ . '/.env';
        if (file_exists($envFile)) {
            $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
            foreach ($lines as $line) {
                if (strpos(trim($line), '#') === 0) {
                    continue;
                }
                
                list($name, $value) = explode('=', $line, 2);
                $name = trim($name);
                $value = trim($value);
                
                if (!array_key_exists($name, $_SERVER) && !array_key_exists($name, $_ENV)) {
                    putenv(sprintf('%s=%s', $name, $value));
                    $_ENV[$name] = $value;
                    $_SERVER[$name] = $value;
                }
            }
        }
    }

    public function num_table_results($table)
    {
        // Sanitize table name to prevent SQL injection
        $table = $this->sanitizeTableName($table);
        
        $sql = "SELECT * FROM $table";
        $query = mysqli_query($this->conn, $sql);
        return mysqli_num_rows($query);
    }

    public function resultsall($table)
    {
        global $db;
        // Sanitize table name to prevent SQL injection
        $table = $this->sanitizeTableName($table);
        
        $sql = "SELECT * FROM " . $table;
        $query = $db->prepare($sql);
        $query->execute();
        return $query->fetchAll();
    }

    public function resultsalllimt($table, $limit)
    {
        global $db;
        // Sanitize table name to prevent SQL injection
        $table = $this->sanitizeTableName($table);
        
        $sql = "SELECT * FROM " . $table . " LIMIT ?";
        $query = $db->prepare($sql);
        $query->bindParam(1, $limit, PDO::PARAM_INT);
        $query->execute();
        return $query->fetchAll();
    }

    public function resultsalllimtn($table, $limit)
    {
        global $db;
        // Sanitize table name to prevent SQL injection
        $table = $this->sanitizeTableName($table);
        
        $sql = "SELECT * FROM " . $table . " ORDER BY id LIMIT ?";
        $query = $db->prepare($sql);
        $query->bindParam(1, $limit, PDO::PARAM_INT);
        $query->execute();
        return $query->fetchAll();
    }

    public function resultsallDESC($table)
    {
        global $db;
        // Sanitize table name to prevent SQL injection
        $table = $this->sanitizeTableName($table);
        
        $sql = "SELECT * FROM " . $table . " ORDER BY id DESC";
        $query = $db->prepare($sql);
        $query->execute();
        return $query->fetchAll();
    }

    public function joinfetch($table1, $table2, $column, $value)
    {
        global $db;
        // Sanitize table and column names
        $table1 = $this->sanitizeTableName($table1);
        $table2 = $this->sanitizeTableName($table2);
        $column = $this->sanitizeColumnName($column);
        
        $sql = "SELECT $table1.*, $table2.* FROM $table1 INNER JOIN $table2 ON $table1.id = $table2.$column WHERE $table1.id = ?";
        $query = $db->prepare($sql);
        $query->bindParam(1, $value, PDO::PARAM_INT);
        $query->execute();
        return $query->fetchAll();
    }

    public function joinfetchSingle($table1, $table2, $column, $value, $colou)
    {
        global $db;
        // Sanitize table and column names
        $table1 = $this->sanitizeTableName($table1);
        $table2 = $this->sanitizeTableName($table2);
        $column = $this->sanitizeColumnName($column);
        $colou = $this->sanitizeColumnName($colou);
        
        $sql = "SELECT $table1.*, $table2.* FROM $table1 INNER JOIN $table2 ON $table1.id = $table2.$column WHERE $table1.$colou = ?";
        $query = $db->prepare($sql);
        $query->bindParam(1, $value, PDO::PARAM_STR);
        $query->execute();
        return $query->fetchAll();
    }

    public function fetchsingle($table, $array)
    {
        global $db;
        // Sanitize table name
        $table = $this->sanitizeTableName($table);
        
        $conditions = [];
        $params = [];
        
        foreach ($array as $key => $element) {
            // Sanitize column name
            $key = $this->sanitizeColumnName($key);
            $conditions[] = "$key = ?";
            $params[] = $element;
        }
        
        $sql = "SELECT * FROM $table WHERE " . implode(" AND ", $conditions);
        $query = $db->prepare($sql);
        
        // Bind parameters
        for ($i = 0; $i < count($params); $i++) {
            $query->bindParam($i + 1, $params[$i], is_int($params[$i]) ? PDO::PARAM_INT : PDO::PARAM_STR);
        }
        
        $query->execute($params); // Using array for execution simplifies binding
        return $query->fetch();
    }

    public function fetchsingleDESC($table, $array, $order)
    {
        global $db;
        // Sanitize table and column names
        $table = $this->sanitizeTableName($table);
        $order = $this->sanitizeColumnName($order);
        
        $conditions = [];
        $params = [];
        
        foreach ($array as $key => $element) {
            // Sanitize column name
            $key = $this->sanitizeColumnName($key);
            $conditions[] = "$key = ?";
            $params[] = $element;
        }
        
        $sql = "SELECT * FROM $table WHERE " . implode(" AND ", $conditions) . " ORDER BY $order DESC";
        $query = $db->prepare($sql);
        
        $query->execute($params); // Using array for execution simplifies binding
        return $query->fetch();
    }

    public function fetchsinglepost($table, $array, $limit)
    {
        global $db;
        // Sanitize table name
        $table = $this->sanitizeTableName($table);
        
        $conditions = [];
        $params = [];
        
        foreach ($array as $key => $element) {
            // Sanitize column name
            $key = $this->sanitizeColumnName($key);
            $conditions[] = "$key = ?";
            $params[] = $element;
        }
        
        $sql = "SELECT * FROM $table WHERE " . implode(" AND ", $conditions) . " ORDER BY id DESC LIMIT ?";
        $params[] = (int)$limit;
        
        $query = $db->prepare($sql);
        $query->execute($params);
        return $query->fetchAll();
    }

    public function allpost($table, $array)
    {
        global $db;
        // Sanitize table name
        $table = $this->sanitizeTableName($table);
        
        $conditions = [];
        $params = [];
        
        foreach ($array as $key => $element) {
            // Sanitize column name
            $key = $this->sanitizeColumnName($key);
            $conditions[] = "$key = ?";
            $params[] = $element;
        }
        
        $sql = "SELECT * FROM $table WHERE " . implode(" AND ", $conditions) . " ORDER BY id DESC";
        $query = $db->prepare($sql);
        $query->execute($params);
        return $query->fetchAll();
    }

    public function fetchallnorder($table, $array)
    {
        global $db;
        // Sanitize table name
        $table = $this->sanitizeTableName($table);
        
        $conditions = [];
        $params = [];
        
        foreach ($array as $key => $element) {
            // Sanitize column name
            $key = $this->sanitizeColumnName($key);
            $conditions[] = "$key = ?";
            $params[] = $element;
        }
        
        $sql = "SELECT * FROM $table WHERE " . implode(" AND ", $conditions) . " ORDER BY id";
        $query = $db->prepare($sql);
        $query->execute($params);
        return $query->fetchAll();
    }

    public function fetchalln($table, $array)
    {
        global $db;
        // Sanitize table name
        $table = $this->sanitizeTableName($table);
        
        $conditions = [];
        $params = [];
        
        foreach ($array as $key => $element) {
            // Sanitize column name
            $key = $this->sanitizeColumnName($key);
            $conditions[] = "$key = ?";
            $params[] = $element;
        }
        
        $sql = "SELECT * FROM $table WHERE " . implode(" AND ", $conditions) . " ORDER BY id DESC";
        $query = $db->prepare($sql);
        $query->execute($params);
        return $query->fetchAll();
    }

    public function fetchallnlimit($table, $array, $limit)
    {
        global $db;
        // Sanitize table name
        $table = $this->sanitizeTableName($table);
        
        $conditions = [];
        $params = [];
        
        foreach ($array as $key => $element) {
            // Sanitize column name
            $key = $this->sanitizeColumnName($key);
            $conditions[] = "$key = ?";
            $params[] = $element;
        }
        
        $sql = "SELECT * FROM $table WHERE " . implode(" AND ", $conditions) . " ORDER BY id DESC LIMIT ?";
        $params[] = (int)$limit;
        
        $query = $db->prepare($sql);
        $query->execute($params);
        return $query->fetchAll();
    }

    public function fetchallnlimitid($table, $array, $limit, $id)
    {
        global $db;
        // Sanitize table and column names
        $table = $this->sanitizeTableName($table);
        $id = $this->sanitizeColumnName($id);
        
        $conditions = [];
        $params = [];
        
        foreach ($array as $key => $element) {
            // Sanitize column name
            $key = $this->sanitizeColumnName($key);
            $conditions[] = "$key = ?";
            $params[] = $element;
        }
        
        $sql = "SELECT * FROM $table WHERE " . implode(" AND ", $conditions) . " ORDER BY $id DESC LIMIT ?";
        $params[] = (int)$limit;
        
        $query = $db->prepare($sql);
        $query->execute($params);
        return $query->fetchAll();
    }

    public function search($table, $array, $search)
    {
        global $db;
        // Sanitize table name
        $table = $this->sanitizeTableName($table);
        
        $conditions = [];
        $params = [];
        
        foreach ($array as $key => $element) {
            // Sanitize column name
            $key = $this->sanitizeColumnName($key);
            $conditions[] = "$key = ?";
            $params[] = $element;
        }
        
        $searchValue = "%$search%";
        $sql = "SELECT * FROM $table WHERE " . implode(" AND ", $conditions) . " AND (P_title LIKE ? OR meta_desc LIKE ?)";
        $params[] = $searchValue;
        $params[] = $searchValue;
        
        $query = $db->prepare($sql);
        $query->execute($params);
        return $query->fetchAll();
    }

    public function fetchsingle_array($table, $array)
    {
        global $db;
        // Sanitize table name
        $table = $this->sanitizeTableName($table);
        
        $conditions = [];
        $params = [];
        
        foreach ($array as $key => $element) {
            // Sanitize column name
            $key = $this->sanitizeColumnName($key);
            $conditions[] = "$key = ?";
            $params[] = $element;
        }
        
        $sql = "SELECT * FROM $table WHERE " . implode(" AND ", $conditions);
        $query = $db->prepare($sql);
        $query->execute($params);
        return $query->fetchAll();
    }

    public function fetchall($sql)
    {
        global $db;
        // Note: This method assumes SQL is already properly formed and secure
        // It is recommended to use the other methods instead where possible
        $query = $db->prepare($sql);
        $query->execute();
        return $query->fetchAll();
    }

    public function fetch($sql)
    {
        global $db;
        // Note: This method assumes SQL is already properly formed and secure
        // It is recommended to use the other methods instead where possible
        $query = $db->prepare($sql);
        $query->execute();
        return $query->fetch();
    }

    public function num_rows($table, $array)
    {
        global $db;
        // Sanitize table name
        $table = $this->sanitizeTableName($table);
        
        $conditions = [];
        $params = [];
        
        foreach ($array as $key => $element) {
            // Sanitize column name
            $key = $this->sanitizeColumnName($key);
            $conditions[] = "$key = ?";
            $params[] = $element;
        }
        
        $sql = "SELECT * FROM $table WHERE " . implode(" AND ", $conditions);
        $query = $db->prepare($sql);
        $query->execute($params);
        return $query->rowCount();
    }

    public function update($table, $array, $warray)
    {
        global $db;
        // Sanitize table name
        $table = $this->sanitizeTableName($table);
        
        $setFields = [];
        $whereFields = [];
        $params = [];
        
        // SET clause
        foreach ($array as $key => $element) {
            // Sanitize column name
            $key = $this->sanitizeColumnName($key);
            $setFields[] = "$key = ?";
            $params[] = $element;
        }
        
        // WHERE clause
        foreach ($warray as $key => $element) {
            // Sanitize column name
            $key = $this->sanitizeColumnName($key);
            $whereFields[] = "$key = ?";
            $params[] = $element;
        }
        
        $sql = "UPDATE $table SET " . implode(", ", $setFields) . " WHERE " . implode(" AND ", $whereFields);
        $query = $db->prepare($sql);
        $query->execute($params);
        
        // For compatibility with original code
        return mysqli_affected_rows($this->conn);
    }

    public function insert($table, $array)
    {
        global $db;
        // Sanitize table name
        $table = $this->sanitizeTableName($table);
        
        $columns = [];
        $placeholders = [];
        $values = [];
        
        foreach ($array as $key => $element) {
            // Sanitize column name
            $key = $this->sanitizeColumnName($key);
            $columns[] = $key;
            $placeholders[] = "?";
            $values[] = $element;
        }
        
        $sql = "INSERT INTO $table (" . implode(", ", $columns) . ") VALUES (" . implode(", ", $placeholders) . ")";
        $query = $db->prepare($sql);
        $query->execute($values);
        
        // For compatibility with original code
        $last_id = mysqli_insert_id($this->conn);
        return $last_id;
    }

    public function delete($table, $array)
    {
        global $db;
        // Sanitize table name
        $table = $this->sanitizeTableName($table);
        
        $conditions = [];
        $params = [];
        
        foreach ($array as $key => $element) {
            // Sanitize column name
            $key = $this->sanitizeColumnName($key);
            $conditions[] = "$key = ?";
            $params[] = $element;
        }
        
        $sql = "DELETE FROM $table WHERE " . implode(" AND ", $conditions);
        $query = $db->prepare($sql);
        $query->execute($params);
        
        // For compatibility with original code
        return mysqli_affected_rows($this->conn);
    }
    
    /**
     * Helper function to sanitize table names
     */
    private function sanitizeTableName($name) {
        return preg_replace('/[^a-zA-Z0-9_]/', '', $name);
    }
    
    /**
     * Helper function to sanitize column names
     */
    private function sanitizeColumnName($name) {
        return preg_replace('/[^a-zA-Z0-9_]/', '', $name);
    }
    
    /**
     * Get a database connection using environment variables
     */
    public static function getDbConnection() {
        self::loadEnv();
        
        $host = getenv('DB_HOST') ?: 'localhost';
        $dbname = getenv('DB_NAME') ?: 'truekcqo_caelius';
        $username = getenv('DB_USER') ?: 'truekcqo_caelius';
        $password = getenv('DB_PASS') ?: 'S9x=#8q2JtXt';
        
        try {
            $conn = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
            $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            return $conn;
        } catch(PDOException $e) {
            // Log the error securely without exposing details
            error_log("Database connection error: " . $e->getMessage());
            die("Service temporarily unavailable");
        }
    }
}