<?php
// Include session configuration first
require_once __DIR__ . '/session-config.php';
require_once __DIR__ . '/security/nonce-manager.php';

// Ensure security files are included
$securityFilePath = __DIR__ . '/security.php';
if (file_exists($securityFilePath)) {
    require_once $securityFilePath;
}

// Ensure SRI implementation is included
$sriFilePath = __DIR__ . '/security/sri-implementation.php';
if (file_exists($sriFilePath)) {
    require_once $sriFilePath;
}

// Get nonce for CSP
$cspNonce = get_nonce('csp');

// Set CSP header with nonce - Updated to allow necessary resources
$csp = "default-src 'self'; " .
       "script-src 'self' 'nonce-{$cspNonce}' 'unsafe-inline' https://ajax.googleapis.com https://cdnjs.cloudflare.com https://code.jquery.com https://cdn.jsdelivr.net https://www.googletagmanager.com https://www.google.com https://www.gstatic.com https://www.google-analytics.com; " .
       "style-src 'self' 'unsafe-inline' https://cdnjs.cloudflare.com https://cdn.jsdelivr.net https://fonts.googleapis.com; " .
       "img-src 'self' data: https: https://www.caeliusconsulting.com https://www.google-analytics.com; " .
       "connect-src 'self' https://www.google-analytics.com; " .
       "font-src 'self' data: https://cdnjs.cloudflare.com https://cdn.jsdelivr.net https://fonts.gstatic.com https://fonts.googleapis.com; " .
       "frame-src 'self' https://www.google.com; " .
       "object-src 'none'; " .
       "base-uri 'self'; " .
       "form-action 'self'; " .
       "frame-ancestors 'self'; " .
       "upgrade-insecure-requests; " .
       "block-all-mixed-content";

header("Content-Security-Policy: {$csp}");

// Now start output buffer
ob_start();

// Error reporting - should be disabled in production
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

// Set memory limit and timezone
ini_set('memory_limit', '256M');
date_default_timezone_set('America/New_York');

// Load environment variables if .env file exists
function loadEnv() {
    $envFile = __DIR__ . '/.env';
    if (file_exists($envFile)) {
        $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        foreach ($lines as $line) {
            if (strpos(trim($line), '#') === 0) {
                continue;
            }
            
            list($name, $value) = explode('=', $line, 2);
            $name = trim($name);
            $value = trim($value);
            
            if (!array_key_exists($name, $_SERVER) && !array_key_exists($name, $_ENV)) {
                putenv(sprintf('%s=%s', $name, $value));
                $_ENV[$name] = $value;
                $_SERVER[$name] = $value;
            }
        }
    }
}

// Load environment variables
loadEnv();

// Date formatting functions
function dateWithFormat($date){
    return date('d-m-Y', strtotime($date));
}

function datehrsWithFormat($date){
    return date('d-m-Y H:i:s', strtotime($date));
}

// Database connection with error handling
try {
    // Try to get credentials from environment variables first
    $db_host = getenv('DB_HOST') ?: 'localhost';
    $db_name = getenv('DB_NAME') ?: 'truekcqo_caelius';
    $db_user = getenv('DB_USER') ?: 'truekcqo_caelius';
    $db_pass = getenv('DB_PASS') ?: 'Sabre#567';
    
    // Create PDO connection
    $db = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $db->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
    
    // Legacy mysqli connection for backward compatibility
    $conn = mysqli_connect($db_host, $db_user, $db_pass, $db_name);
    
    if (!$conn) {
        // Log error but don't expose details
        error_log('Database connection failed: ' . mysqli_connect_error());
        throw new Exception('Database connection failed');
    }
} catch (Exception $e) {
    // Log error but don't expose details
    error_log('Database connection error: ' . $e->getMessage());
    die("The system is currently unavailable. Please try again later.");
}

// Initialize data class with connection
require_once 'class.php';
$classConn = new data($conn);

// Site URLs and paths
$base_url = getenv('SITE_URL') ?: 'https://www.caeliusconsulting.com/';
$base_path = $_SERVER['DOCUMENT_ROOT'];
$company = getenv('SITE_NAME') ?: 'Caelius Consulting';

// Set SendGrid SMTP configuration from environment or defaults
$smtp_host = getenv('SMTP_HOST') ?: 'smtp.sendgrid.net';
$smtp_port = getenv('SMTP_PORT') ?: 587;
$smtp_user = getenv('SMTP_USER') ?: 'apikey';
$smtp_pass = getenv('SMTP_PASS') ?: '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';
$from_email = getenv('SMTP_FROM_EMAIL') ?: 'noreply@caeliusconsulting.com';
$from_name = getenv('SMTP_FROM_NAME') ?: 'Caelius Consulting';

// Primary navigation
$primary_nav = [
    'Home' => '/',
    'Services' => [
        'MuleSoft Expertise' => '/mulesoft_expertise',
        'Salesforce Services' => '/salesforce_services',
        'Snowflake Services' => '/snowflake',
        'Spring Boot Services' => '/spring_boot',
        'Testing Services' => '/testing_services'
    ],
    'About Us' => '/about_us',
    'Careers' => '/career',
    'News & Events' => '/news_events',
    'Contact Us' => '/contact_us'
];
?>