<?php
require_once('config.php');

// Generate a nonce for inline scripts
$nonce = base64_encode(random_bytes(16));
header("Content-Security-Policy-Report-Only: default-src 'self'; script-src 'self' 'nonce-{$nonce}' 'unsafe-inline' https: 'unsafe-eval'; style-src 'self' 'unsafe-inline' https:; img-src 'self' data: https:; font-src 'self' https: data:; connect-src 'self' https:;");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CSP Debug Page</title>
    <script nonce="<?php echo $nonce; ?>">
        // Listen for CSP violations
        document.addEventListener('securitypolicyviolation', (e) => {
            console.log('CSP Violation:', {
                'Blocked URI': e.blockedURI,
                'Violated Directive': e.violatedDirective,
                'Original Policy': e.originalPolicy
            });
            
            // Add to page
            const violationDiv = document.createElement('div');
            violationDiv.style.color = 'red';
            violationDiv.innerHTML = `CSP Violation:<br>
                Blocked URI: ${e.blockedURI}<br>
                Violated Directive: ${e.violatedDirective}<br>
                Original Policy: ${e.originalPolicy}`;
            document.getElementById('violations').appendChild(violationDiv);
        });

        // Function to test loading a resource
        function testResource(url, type) {
            return new Promise((resolve, reject) => {
                let element;
                switch(type) {
                    case 'script':
                        element = document.createElement('script');
                        element.src = url;
                        break;
                    case 'style':
                        element = document.createElement('link');
                        element.rel = 'stylesheet';
                        element.href = url;
                        break;
                    case 'font':
                        // Test font loading through CSS
                        element = document.createElement('link');
                        element.rel = 'stylesheet';
                        element.href = url;
                        break;
                }

                element.onload = () => resolve(`Successfully loaded ${type}: ${url}`);
                element.onerror = () => reject(`Failed to load ${type}: ${url}`);

                document.head.appendChild(element);
            });
        }
    </script>
</head>
<body>
    <h1>CSP Debug Page</h1>
    
    <h2>Current Headers:</h2>
    <pre><?php
        foreach (headers_list() as $header) {
            if (stripos($header, 'content-security-policy') !== false) {
                echo htmlspecialchars($header) . "\n";
            }
        }
    ?></pre>

    <h2>Resource Tests:</h2>
    <div id="results"></div>

    <h2>CSP Violations:</h2>
    <div id="violations"></div>

    <script nonce="<?php echo $nonce; ?>">
        // Test critical resources
        const resources = [
            { url: 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css', type: 'style' },
            { url: 'https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css', type: 'style' },
            { url: 'https://unpkg.com/aos@2.3.1/dist/aos.css', type: 'style' },
            { url: 'https://code.jquery.com/jquery-3.6.0.min.js', type: 'script' },
            { url: 'https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js', type: 'script' },
            { url: 'https://unpkg.com/aos@2.3.1/dist/aos.js', type: 'script' },
            { url: 'https://www.googletagmanager.com/gtag/js', type: 'script' }
        ];

        const resultsDiv = document.getElementById('results');
        resources.forEach(resource => {
            testResource(resource.url, resource.type)
                .then(message => {
                    const div = document.createElement('div');
                    div.style.color = 'green';
                    div.textContent = message;
                    resultsDiv.appendChild(div);
                })
                .catch(error => {
                    const div = document.createElement('div');
                    div.style.color = 'red';
                    div.textContent = error;
                    resultsDiv.appendChild(div);
                });
        });
    </script>
</body>
</html> 