<?php
// Enable error display for debugging purposes only - REMOVE IN PRODUCTION
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Set memory limit
ini_set('memory_limit', '256M');

// Store original error log for reference
$original_error_log = ini_get('error_log');
echo "Original error log path: " . $original_error_log . "<br>";

// Check if error log is writable
if (file_exists($original_error_log)) {
    echo "Error log exists, checking if writable: " . (is_writable($original_error_log) ? 'Yes' : 'No') . "<br>";
} else {
    echo "Error log file doesn't exist or is in a different location.<br>";
}

// Print PHP version information
echo "PHP Version: " . phpversion() . "<br>";
echo "PHP SAPI: " . php_sapi_name() . "<br>";

// Check if required extensions are loaded
$required_extensions = array('PDO', 'pdo_mysql', 'mbstring', 'fileinfo', 'session');
echo "<h3>Required Extensions:</h3>";
foreach ($required_extensions as $ext) {
    echo "$ext: " . (extension_loaded($ext) ? 'Loaded' : 'Not loaded') . "<br>";
}

// Try loading the environment variables
echo "<h3>Environment Testing:</h3>";
$env_file = __DIR__ . '/.env';
if (file_exists($env_file)) {
    echo ".env file exists, checking if readable: " . (is_readable($env_file) ? 'Yes' : 'No') . "<br>";
    
    if (is_readable($env_file)) {
        try {
            $env_content = file_get_contents($env_file);
            echo "First few characters of .env file: " . htmlspecialchars(substr($env_content, 0, 50)) . "...<br>";
        } catch (Exception $e) {
            echo "Error reading .env file: " . $e->getMessage() . "<br>";
        }
    }
} else {
    echo ".env file does not exist<br>";
}

// Test loading the security.php file
echo "<h3>Security Module Test:</h3>";
if (file_exists('security.php')) {
    echo "security.php exists, attempting to include...<br>";
    try {
        include_once 'security.php';
        echo "security.php included successfully.<br>";
        if (function_exists('sanitizeOutput')) {
            echo "sanitizeOutput function exists.<br>";
        } else {
            echo "sanitizeOutput function missing!<br>";
        }
    } catch (Exception $e) {
        echo "Error including security.php: " . $e->getMessage() . "<br>";
    }
} else {
    echo "security.php does not exist<br>";
}

// Test database connection
echo "<h3>Database Connection Test:</h3>";
try {
    // Try to load environment variables directly
    function loadTestEnv() {
        $envFile = __DIR__ . '/.env';
        if (file_exists($envFile)) {
            $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
            foreach ($lines as $line) {
                if (strpos(trim($line), '#') === 0) {
                    continue;
                }
                
                list($name, $value) = explode('=', $line, 2);
                $name = trim($name);
                $value = trim($value);
                
                putenv(sprintf('%s=%s', $name, $value));
                $_ENV[$name] = $value;
                $_SERVER[$name] = $value;
            }
        }
    }
    
    loadTestEnv();
    
    // Use fallback values if environment variables aren't available
    $db_host = getenv('DB_HOST') ?: 'localhost';
    $db_name = getenv('DB_NAME') ?: 'truekcqo_caelius';
    $db_user = getenv('DB_USER') ?: 'truekcqo_caelius';
    $db_pass = getenv('DB_PASS') ?: 'S9x=#8q2JtXt';
    
    echo "Testing connection to: $db_host / $db_name<br>";
    
    $conn = new PDO("mysql:host=$db_host;dbname=$db_name", $db_user, $db_pass);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "Database connection successful!<br>";
    
    // Test a simple query
    $stmt = $conn->query("SELECT 1");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "Test query result: " . print_r($result, true) . "<br>";
    
} catch (PDOException $e) {
    echo "Database connection failed: " . $e->getMessage() . "<br>";
}

// Check for the class.php file
echo "<h3>Class Implementation Test:</h3>";
if (file_exists('class.php')) {
    echo "class.php exists.<br>";
} else {
    echo "class.php missing!<br>";
}

if (file_exists('secure-class.php')) {
    echo "secure-class.php exists.<br>";
} else {
    echo "secure-class.php missing!<br>";
}

// Check for config.php
if (file_exists('config.php')) {
    echo "config.php exists.<br>";
} else {
    echo "config.php missing!<br>";
}

if (file_exists('secure-config.php')) {
    echo "secure-config.php exists.<br>";
} else {
    echo "secure-config.php missing!<br>";
}

// Include path and loaded files
echo "<h3>PHP Include Path:</h3>";
echo ini_get('include_path') . "<br>";

echo "<h3>End of diagnostic script</h3>";
?> 