<?php
// Enable error reporting
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Output basic PHP info
echo "<h1>PHP Debug Information</h1>";
echo "<p>PHP Version: " . phpversion() . "</p>";

// Check if key files exist
echo "<h2>File Existence Check:</h2>";
$files_to_check = [
    'security.php',
    'security/sri-implementation.php',
    'security/nonce-manager.php',
    'config.php',
    'header.php',
    'footer.php'
];

echo "<ul>";
foreach ($files_to_check as $file) {
    echo "<li>" . $file . ": " . (file_exists($file) ? "Exists" : "Missing") . "</li>";
}
echo "</ul>";

// Try to include each file with error catching
echo "<h2>File Include Test:</h2>";
echo "<ul>";

function test_require($file) {
    try {
        require_once $file;
        echo "<li>Successfully included: " . $file . "</li>";
    } catch (Throwable $e) {
        echo "<li>Error including " . $file . ": " . $e->getMessage() . "</li>";
    }
}

// Test security files first
if (file_exists('security/nonce-manager.php')) {
    test_require('security/nonce-manager.php');
}

if (file_exists('security/sri-implementation.php')) {
    test_require('security/sri-implementation.php');
}

// Then try the main files
if (file_exists('security.php')) {
    test_require('security.php');
}

echo "</ul>";

// Show last few lines of error log if accessible
echo "<h2>Recent Error Log:</h2>";
$error_log = ini_get('error_log');
echo "<p>Error log path: " . ($error_log ?: "Not set") . "</p>";

if ($error_log && file_exists($error_log)) {
    $log_content = shell_exec('tail -n 20 ' . escapeshellarg($error_log));
    echo "<pre>" . htmlspecialchars($log_content) . "</pre>";
} else {
    echo "<p>Could not access error log.</p>";
}

// Print the include path
echo "<h2>Include Path:</h2>";
echo "<pre>" . htmlspecialchars(get_include_path()) . "</pre>";

// Show any constants that might be relevant
echo "<h2>Common Constants:</h2>";
echo "<p>__DIR__: " . __DIR__ . "</p>";
echo "<p>__FILE__: " . __FILE__ . "</p>";
?> 