<?php
/**
 * Main Configuration File
 * Contains database connection parameters, SMTP settings, and other configuration
 * 
 * IMPORTANT: This file contains sensitive information and should be properly secured
 */

// Prevent direct access to this file
if (!defined('SECURE_ACCESS') && basename($_SERVER['PHP_SELF']) == basename(__FILE__)) {
    header('HTTP/1.0 403 Forbidden');
    exit('Direct access to this file is not allowed.');
}

// Set error reporting
ini_set('display_errors', 0);
error_reporting(E_ALL & ~E_NOTICE);

// Session security settings
ini_set('session.cookie_httponly', 1);
ini_set('session.cookie_secure', 1);
ini_set('session.cookie_samesite', 'Lax');
ini_set('session.use_strict_mode', 1);
ini_set('session.use_only_cookies', 1);

// Site configuration
define('SITE_NAME', 'Caelius Consulting');
define('SITE_URL', 'https://www.caeliusconsulting.com/');
define('ADMIN_EMAIL', 'hr@caeliusconsulting.com');

// Database credentials
define('DB_HOST', 'localhost');
define('DB_NAME', 'truekcqo_caelius');
define('DB_USER', 'truekcqo_caelius');
define('DB_PASS', 'S9x=#8q2JtXt');

// SMTP Configuration
define('SMTP_HOST', 'smtp.gmail.com');  
define('SMTP_PORT', 587);               
define('SMTP_USER', 'info@caeliusconsulting.com');  
define('SMTP_PASS', 'yfnjwmzvxvdwnmni');  
define('SMTP_SECURE', 'tls');           
define('SMTP_FROM_EMAIL', 'info@caeliusconsulting.com');  
define('SMTP_FROM_NAME', 'Caelius Consulting');  
define('CONTACT_EMAIL', 'info@caeliusconsulting.com');  
define('CONTACT_NAME', 'Caelius Support');  

// File upload settings
define('MAX_UPLOAD_SIZE', 5 * 1024 * 1024); // 5MB
define('UPLOAD_DIR', dirname(__DIR__) . '/uploads/');
define('ALLOWED_EXTENSIONS', ['pdf', 'doc', 'docx']);

// Security settings
define('CSRF_EXPIRATION', 3600); // 1 hour
define('PASSWORD_COST', 12); // For password_hash

/**
 * Environment detection 
 * Auto-detects whether we're in development or production environment
 */
function isProduction() {
    $prodDomains = ['caeliusconsulting.com', 'www.caeliusconsulting.com'];
    $serverName = isset($_SERVER['SERVER_NAME']) ? $_SERVER['SERVER_NAME'] : '';
    
    return in_array($serverName, $prodDomains);
}

// Define environment-specific settings
define('IS_PRODUCTION', isProduction());
define('DEBUG_MODE', !IS_PRODUCTION);

// Show errors in development only
if (!IS_PRODUCTION) {
    ini_set('display_errors', 1);
}

// Define secure access constant to allow inclusion
define('SECURE_ACCESS', true);
?> 