$(document).ready(function (e){
// Get CSRF token from meta tag or hidden input
function getCSRFToken() {
    // First try to get it from meta tag
    var token = $('meta[name="csrf-token"]').attr('content');
    // If not found, try to get it from hidden input
    if (!token) {
        token = $('input[name="csrf_token"]').val();
    }
    return token;
}

// Check if CSRF token exists in form, if not add it
function ensureCSRFToken() {
    var token = getCSRFToken();
    if (token && !$("#frmEnquiry input[name='csrf_token']").length) {
        $("#frmEnquiry").append('<input type="hidden" name="csrf_token" value="' + token + '">');
    }
}

// Call this when document is ready
ensureCSRFToken();

$("#frmEnquiry").on('submit',(function(e){
	// $('#btnSendMail').prop('disabled', false);
	e.preventDefault();
	
	// Make sure CSRF token is present before submitting
	ensureCSRFToken();
	
	var valid;	
	valid = validateContact();
	
	
	if(valid) {
		$("#btnSendMail").text("Submitting...");
		$('#lblcaptchaError').html('');
		$.ajax({
		url: "../mail/mail-send-career.php",
		type: "POST",
		data:  new FormData(this),
		contentType: false,
		cache: false,
		processData:false,
		success: function(data){
		console.log("Form submission response:", data); // Enhanced logging for debugging
		if(data==1)
		{
			alert("Something went wrong. Please try again or contact support.");
			$("#btnSendMail").text("Submit");
			$("#mail-status").html('<p class="error">Failed to submit the form. Please try again.</p>');
		}
		else
		{
			alert("Your application has been submitted successfully!");
			$("#btnSendMail").text("Submit");
			$("#mail-status").html('<p class="success">Application submitted successfully!</p>');
		}
	    document.getElementById("frmEnquiry").reset();
		$("#lbluploadError").empty();
		},
		error: function(xhr, status, error){
			console.error("Form submission error:", status, error); 
			console.error("Error details:", xhr.responseText); // Enhanced error logging
			$("#mail-status").html('<p class="error">An error occurred. Please try again later.</p>');
			$("#btnSendMail").text("Submit");
		} 	        
		
		});
	}
}));

function validateContact() {
	var valid = true;	
	var imgVal = $('#fileUploadimage').val();
	var autocaptcha=$('#txt_captcha').html();
	var inputcaptcha=$('#txt_captcha_code').val();
	var fi = document.getElementById('fileUploadimage'); 
	
	$(".demoInputBox").css('background-color','');
	$(".info").html('');
	$("#name").removeClass("invalid");
	$("#email").removeClass("invalid");
	$("#phone").removeClass("invalid");
	$("#code").removeClass("invalid");

	
	if(!$("#name").val()) {
		$("#name").addClass("invalid");
        $("#name").attr("title","Required");
        valid = false;
	} else if($("#name").val().length < 2) {
		$("#name").addClass("invalid");
        $("#name").attr("title","Name must be at least 2 characters");
        valid = false;
	}
    if(!$("#email").val()) {
        $("#email").addClass("invalid");
        $("#email").attr("title","Required");
        valid = false;
    } else if(!$("#email").val().match(/^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/)) {
        $("#email").addClass("invalid");
        $("#email").attr("title","Invalid Email");
        valid = false;
    }
	if(!$("#phone").val()) {
		$("#phone").addClass("invalid");
        $("#phone").attr("title","Required");
		valid = false;
	}
	if(!$("#code").val()) {
		$("#code").addClass("invalid");
        $("#code").attr("title","Required");
		valid = false;
	}
	
	// Improved validation for phone numbers
	var phoneRegex = /^[0-9\+\-\(\) ]{6,20}$/;
	if (!phoneRegex.test($("#phone").val())) {
		$("#phone").addClass("invalid");
		$("#phone").attr("title", "Please enter a valid phone number");
		valid = false;
	}
	
	if(imgVal=='')
    {
        $('#lbluploadError').html('Resume is required');
		valid = false;
    }
	
	// Validate file type
	if (fi.files.length > 0) {
		var fileName = fi.files[0].name;
		var fileExt = fileName.split('.').pop().toLowerCase();
		var allowedExts = ['pdf', 'doc', 'docx'];
		
		if (allowedExts.indexOf(fileExt) === -1) {
			$('#lbluploadError').html('Only PDF, DOC, and DOCX files are accepted');
			valid = false;
		}
		
		if(fi.files[0].size > 0)
		{
			var _size = fi.files[0].size;
			var sizemb = Math.floor(_size/1000000);
			if(sizemb > 5)
			{
				$('#lbluploadError').html('File size must be less than 5MB');
				valid = false;
			}
		}
	}
	
	// If we have a captcha, validate it
	if (autocaptcha && inputcaptcha) {
	    if (inputcaptcha.trim() === '') {
	        $('#lblcaptchaError').html('Please enter the captcha code');
	        valid = false;
	    } else if (autocaptcha !== inputcaptcha) {
	        $('#lblcaptchaError').html('Invalid captcha code');
	        valid = false;
	    }
	}
	
	return valid;
}

});

 $(document).ready(function(){
  $("#fileUploadimage").change(function(e){
	  if (!e.target.files || !e.target.files[0]) {
	      $('#lbluploadError').html('');
	      return;
	  }
	  
	  var fileName = e.target.files[0].name;
	  var _size = this.files[0].size;
	  var sizemb = Math.floor(_size/1000000);
	  
	  // Check file extension
	  var fileExt = fileName.split('.').pop().toLowerCase();
	  var allowedExts = ['pdf', 'doc', 'docx'];
	  
	  if (allowedExts.indexOf(fileExt) === -1) {
		  $('#lbluploadError').html('Only PDF, DOC, and DOCX files are accepted');
		  this.value = ''; // Clear the file input
		  return false;
	  }
	  
	  if(sizemb <= 5)
	  {
		  $('#lbluploadError').html('');
	  }
	  else
	  {
		  $('#lbluploadError').html('File size must be less than 5MB');
		  this.value = ''; // Clear the file input
		  return false;
	  }
	  
      var fSExt = new Array('Bytes', 'KB', 'MB', 'GB'),
      i=0;
	  while(_size>900)
	  {
		  _size/=1024;i++;
	  }
      var exactSize = (Math.round(_size*100)/100)+' '+fSExt[i];
      
      $('#lbluploadError').html('<p>File Name: '+fileName+'</br>Size: '+exactSize+'</p>');
  });
 }); 