<?php
// Testing script for career form processing
header('Content-Type: text/plain');

// Log the request for debugging
error_log('Career form test request received: ' . date('Y-m-d H:i:s'));

// Create log directory if needed
if (!is_dir('debug')) {
    mkdir('debug', 0755, true);
}

// Log request details 
$logFile = 'debug/form-debug.log';
$logMessage = date('Y-m-d H:i:s') . " - Process career form test request\n";
$logMessage .= "POST data: " . print_r($_POST, true) . "\n";
$logMessage .= "FILES data: " . print_r($_FILES, true) . "\n";
file_put_contents($logFile, $logMessage, FILE_APPEND);

// Output what we received
echo "Career Form Test Processor\n";
echo "=========================\n\n";
echo "Request received successfully.\n\n";

echo "POST Data:\n";
foreach ($_POST as $key => $value) {
    echo "$key: $value\n";
}

echo "\nFILE Upload Info:\n";
if (isset($_FILES['attachment']) || isset($_FILES['test_resume'])) {
    $file = isset($_FILES['attachment']) ? $_FILES['attachment'] : $_FILES['test_resume'];
    
    if (is_array($file['name'])) {
        // Handle multiple files
        foreach ($file['name'] as $key => $name) {
            echo "File $key: $name\n";
            echo "  Type: " . $file['type'][$key] . "\n";
            echo "  Size: " . $file['size'][$key] . " bytes\n";
            echo "  Temp: " . $file['tmp_name'][$key] . "\n";
            echo "  Error: " . $file['error'][$key] . "\n";
        }
    } else {
        // Single file
        echo "File: " . $file['name'] . "\n";
        echo "  Type: " . $file['type'] . "\n";
        echo "  Size: " . $file['size'] . " bytes\n";
        echo "  Temp: " . $file['tmp_name'] . "\n";
        echo "  Error: " . $file['error'] . "\n";
    }
    
    // Test upload directory
    $uploadDir = 'uploads/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
        echo "\nCreated uploads directory\n";
    }
    
    // Test file upload
    echo "\nTesting file upload capabilities:\n";
    if (is_array($file['name'])) {
        $uploadFile = $uploadDir . basename($file['name'][0]);
        if (move_uploaded_file($file['tmp_name'][0], $uploadFile)) {
            echo "File successfully uploaded to: $uploadFile\n";
        } else {
            echo "File upload failed!\n";
            echo "Error info: " . error_get_last()['message'] . "\n";
        }
    } else if (isset($file['tmp_name']) && !empty($file['tmp_name'])) {
        $uploadFile = $uploadDir . basename($file['name']);
        if (move_uploaded_file($file['tmp_name'], $uploadFile)) {
            echo "File successfully uploaded to: $uploadFile\n";
        } else {
            echo "File upload failed!\n";
            echo "Error info: " . error_get_last()['message'] . "\n";
        }
    }
} else {
    echo "No file uploaded\n";
}

// Return success response
echo "\nResult: Success (2)";
echo "\n\nThis is a test processor. In a real environment, the form would be processed and data saved.";
?> 