<?php
// Enable error display
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Function to display status
function showStatus($message, $success = true) {
    echo '<div style="padding:10px;margin:5px;border-radius:5px;' . 
         ($success ? 'background-color:#d4edda;color:#155724;' : 'background-color:#f8d7da;color:#721c24;') . 
         '">' . $message . '</div>';
}

// Function to restore original files
function restoreBackupFile($file) {
    $backupFile = $file . '.bak';
    
    // Check if backup exists
    if (file_exists($backupFile)) {
        // Restore from backup
        if (copy($backupFile, $file)) {
            showStatus("✅ Successfully restored $file from backup");
            return true;
        } else {
            showStatus("❌ Failed to restore $file from backup", false);
            return false;
        }
    } else {
        showStatus("❓ No backup found for $file", false);
        return false;
    }
}

// Check if restoration is requested
$confirmed = isset($_GET['confirm']) && $_GET['confirm'] === 'yes';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Restore Website Files</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        .container {
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 20px;
            margin-top: 20px;
        }
        .warning {
            background-color: #fff3cd;
            color: #856404;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .btn {
            display: inline-block;
            padding: 10px 15px;
            background-color: #007bff;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin-top: 10px;
        }
        .btn-danger {
            background-color: #dc3545;
        }
        h1, h2 {
            color: #333;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Website Restoration Tool</h1>
        
        <?php if (!$confirmed): ?>
        <div class="warning">
            <strong>Warning!</strong> This tool will restore your website files to their original state before the security fixes were applied.
            Any customizations made during the security implementation may be lost.
        </div>
        
        <h2>Files to be restored:</h2>
        <ul>
            <li>index.php</li>
            <li>config.php</li>
            <li>class.php</li>
            <li>header.php</li>
            <li>footer.php</li>
            <li>.htaccess</li>
            <li>security.php (if exists)</li>
        </ul>
        
        <p>Are you sure you want to proceed with the restoration?</p>
        <a href="?confirm=yes" class="btn btn-danger">Yes, Restore Original Files</a>
        
        <?php else: ?>
        <h2>Restoration Progress:</h2>
        
        <?php
        // List of files to restore
        $filesToRestore = [
            'index.php',
            'config.php',
            'class.php',
            'header.php',
            'footer.php',
            '.htaccess',
            'security.php'
        ];
        
        $successCount = 0;
        $totalFiles = count($filesToRestore);
        
        foreach ($filesToRestore as $file) {
            if (restoreBackupFile($file)) {
                $successCount++;
            }
        }
        
        if ($successCount === $totalFiles) {
            showStatus("🎉 All files have been successfully restored!");
        } else {
            showStatus("⚠️ Restored $successCount out of $totalFiles files", $successCount > 0);
        }
        ?>
        
        <h2>Next Steps:</h2>
        <p>Now that your files have been restored, please check your website to ensure it's functioning correctly.</p>
        <p>If you're still experiencing issues, please contact your developer for further assistance.</p>
        
        <a href="index.php" class="btn">Go to Homepage</a>
        <?php endif; ?>
    </div>
</body>
</html> 