<?php
class NonceManager {
    private static $instance = null;
    private $nonces = [];
    
    private function __construct() {}
    
    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    public function generateNonce($context = 'default') {
        $nonce = bin2hex(random_bytes(16));
        $this->nonces[$context] = $nonce;
        return $nonce;
    }
    
    public function getNonce($context = 'default') {
        if (!isset($this->nonces[$context])) {
            return $this->generateNonce($context);
        }
        return $this->nonces[$context];
    }
    
    public function validateNonce($nonce, $context = 'default') {
        return isset($this->nonces[$context]) && $this->nonces[$context] === $nonce;
    }
    
    public function getAllNonces() {
        return $this->nonces;
    }
}

// Helper functions for easy access
function get_nonce($context = 'default') {
    return NonceManager::getInstance()->getNonce($context);
}

function validate_nonce($nonce, $context = 'default') {
    return NonceManager::getInstance()->validateNonce($nonce, $context);
}

function nonce_tag($context = 'default') {
    $nonce = get_nonce($context);
    return "nonce=\"{$nonce}\"";
} 