<?php
// Enable error display
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Caelius Consulting</title>
    
    <!-- Use CDN for all resources -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
        }
        .header {
            background-color: #2c3e50;
            color: white;
            padding: 2rem 0;
            margin-bottom: 2rem;
        }
        .footer {
            background-color: #2c3e50;
            color: white;
            padding: 1rem 0;
            position: fixed;
            bottom: 0;
            width: 100%;
        }
        .contact-info {
            margin: 2rem 0;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="container">
            <h1>Caelius Consulting</h1>
            <p>Website Maintenance Mode</p>
        </div>
    </div>

    <div class="container">
        <div class="row">
            <div class="col-md-8 mx-auto text-center">
                <h2>We're Performing Website Maintenance</h2>
                <p class="lead">Our website is currently undergoing scheduled maintenance. We apologize for any inconvenience.</p>
                
                <div class="contact-info">
                    <h4>Contact Information</h4>
                    <p><i class="fas fa-envelope"></i> Email: <a href="mailto:info@caeliusconsulting.com">info@caeliusconsulting.com</a></p>
                    <p><i class="fas fa-phone"></i> Phone: <a href="tel:+1-972-370-3073">+1 972 370 3073</a></p>
                </div>
                
                <p>We expect to be back online shortly. Thank you for your patience.</p>
                <p>- The Caelius Consulting Team</p>
            </div>
        </div>
    </div>

    <div class="footer">
        <div class="container">
            <p class="text-center mb-0">&copy; <?php echo date('Y'); ?> Caelius Consulting. All rights reserved.</p>
        </div>
    </div>
</body>
</html> 