<?php
// Start session for CSRF token
session_start();

// Generate a CSRF token if one doesn't exist
if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// Define the target script
$targetScript = 'mail/mail-send-career.php';

// Variables to track response
$response = null;
$errors = [];
$success = false;

// Process form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['test_submit'])) {
    // Create test data
    $testData = [
        'csrf_token' => $_SESSION['csrf_token'],
        'c_name' => $_POST['test_name'] ?? 'Test User',
        'c_email' => $_POST['test_email'] ?? 'test@example.com',
        'c_code' => $_POST['test_code'] ?? '91',
        'c_phone' => $_POST['test_phone'] ?? '1234567890',
        'c_position' => $_POST['test_position'] ?? 'Test Position',
        'c_selected' => $_POST['test_country'] ?? 'in'
    ];
    
    // Log the test submission
    $logFile = 'debug/test_submission.log';
    $logDir = dirname($logFile);
    
    if (!is_dir($logDir)) {
        mkdir($logDir, 0755, true);
    }
    
    $logMessage = date('Y-m-d H:i:s') . " - Test submission initiated\n";
    $logMessage .= "POST data: " . print_r($testData, true) . "\n";
    file_put_contents($logFile, $logMessage, FILE_APPEND);
    
    // Prepare file upload if a file was provided
    if (isset($_FILES['test_resume']) && $_FILES['test_resume']['error'] === UPLOAD_ERR_OK) {
        // Copy the uploaded file
        $tempFile = $_FILES['test_resume']['tmp_name'];
        $fileName = $_FILES['test_resume']['name'];
        
        // Log file details
        $logMessage = "File upload: " . print_r($_FILES['test_resume'], true) . "\n";
        file_put_contents($logFile, $logMessage, FILE_APPEND);
        
        // Create a curl request to the script
        $curl = curl_init();
        
        // Create a temporary file for the request
        $tmpFile = tempnam(sys_get_temp_dir(), 'resume_');
        $cFile = new CURLFile($tempFile, $_FILES['test_resume']['type'], $fileName);
        
        // Set up the POST data
        $postData = $testData;
        $postData['attachment'] = $cFile;
        
        // Set curl options
        curl_setopt_array($curl, [
            CURLOPT_URL => $targetScript,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $postData
        ]);
        
        // Execute the request
        $response = curl_exec($curl);
        $error = curl_error($curl);
        
        // Log the response
        $logMessage = "Response: $response\n";
        if ($error) {
            $logMessage .= "cURL Error: $error\n";
        }
        file_put_contents($logFile, $logMessage, FILE_APPEND);
        
        // Close curl session
        curl_close($curl);
        
        // Clean up
        unlink($tmpFile);
        
        // Check response
        if ($response == '2') {
            $success = true;
        } else {
            $errors[] = "Submission failed with response: $response";
            if ($error) {
                $errors[] = "cURL error: $error";
            }
        }
    } else {
        // Manual form submission (no file)
        $errors[] = "Please select a resume file for testing.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Test Career Form Submission</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            margin: 0;
            padding: 20px;
            color: #333;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
            border: 1px solid #ddd;
            border-radius: 4px;
        }
        h1 {
            color: #444;
            border-bottom: 1px solid #ddd;
            padding-bottom: 10px;
        }
        .form-group {
            margin-bottom: 15px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        input[type="text"],
        input[type="email"],
        select {
            width: 100%;
            padding: 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
        }
        button {
            background-color: #4CAF50;
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        button:hover {
            background-color: #45a049;
        }
        .alert {
            padding: 15px;
            margin-bottom: 20px;
            border: 1px solid transparent;
            border-radius: 4px;
        }
        .alert-success {
            color: #3c763d;
            background-color: #dff0d8;
            border-color: #d6e9c6;
        }
        .alert-danger {
            color: #a94442;
            background-color: #f2dede;
            border-color: #ebccd1;
        }
        .debug-info {
            margin-top: 30px;
            padding: 15px;
            background-color: #f5f5f5;
            border-radius: 4px;
        }
        .debug-info pre {
            white-space: pre-wrap;
            word-wrap: break-word;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Test Career Form Submission</h1>
        
        <?php if ($success): ?>
            <div class="alert alert-success">
                <p>Test submission was successful! Response: <?php echo htmlspecialchars($response); ?></p>
                <p>Check the database for the new entry and verify the file was uploaded correctly.</p>
            </div>
        <?php endif; ?>
        
        <?php if (!empty($errors)): ?>
            <div class="alert alert-danger">
                <strong>Errors:</strong>
                <ul>
                    <?php foreach ($errors as $error): ?>
                        <li><?php echo htmlspecialchars($error); ?></li>
                    <?php endforeach; ?>
                </ul>
            </div>
        <?php endif; ?>
        
        <form method="post" enctype="multipart/form-data">
            <div class="form-group">
                <label for="test_name">Name:</label>
                <input type="text" id="test_name" name="test_name" value="Test User" required>
            </div>
            
            <div class="form-group">
                <label for="test_email">Email:</label>
                <input type="email" id="test_email" name="test_email" value="test@example.com" required>
            </div>
            
            <div class="form-group">
                <label for="test_code">Country Code:</label>
                <input type="text" id="test_code" name="test_code" value="91" required>
            </div>
            
            <div class="form-group">
                <label for="test_phone">Phone:</label>
                <input type="text" id="test_phone" name="test_phone" value="1234567890" required>
            </div>
            
            <div class="form-group">
                <label for="test_position">Position:</label>
                <input type="text" id="test_position" name="test_position" value="Solution Architect" required>
            </div>
            
            <div class="form-group">
                <label for="test_country">Country:</label>
                <select id="test_country" name="test_country" required>
                    <option value="in" selected>India</option>
                    <option value="us">USA</option>
                    <option value="sg">Singapore</option>
                </select>
            </div>
            
            <div class="form-group">
                <label for="test_resume">Resume (PDF, DOC, DOCX):</label>
                <input type="file" id="test_resume" name="test_resume" accept=".pdf,.doc,.docx" required>
            </div>
            
            <button type="submit" name="test_submit">Test Submission</button>
        </form>
        
        <div class="debug-info">
            <h2>Debug Information</h2>
            <p><strong>Target Script:</strong> <?php echo htmlspecialchars($targetScript); ?></p>
            <p><strong>CSRF Token:</strong> <?php echo htmlspecialchars($_SESSION['csrf_token']); ?></p>
            
            <?php if ($response !== null): ?>
                <h3>Response:</h3>
                <pre><?php echo htmlspecialchars($response); ?></pre>
            <?php endif; ?>
            
            <h3>Log Files:</h3>
            <ul>
                <li><a href="view-career-debug.php">View Debug Logs</a> (Password: CaeliusDebug)</li>
                <li><a href="debug-career-form.php">Run Diagnostic Tool</a></li>
            </ul>
        </div>
    </div>
</body>
</html> 