<?php
// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CSP Test Page</title>
    
    <!-- Test Font Loading -->
    <link href="https://fonts.googleapis.com/css?family=Roboto:400,700&display=swap" rel="stylesheet">
    
    <!-- Test Stylesheet Loading from CloudFlare and JSDelivr -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css">
    
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            padding: 20px;
        }
        .success { color: green; }
        .failure { color: red; }
        .test-section {
            margin-bottom: 20px;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>CSP Test Page</h1>
        <p>This page tests various resources that were previously blocked by CSP.</p>
        
        <div class="test-section">
            <h2>Font Awesome Test</h2>
            <p>You should see icons below:</p>
            <div>
                <i class="fas fa-check fa-2x success"></i> 
                <i class="fas fa-times fa-2x failure"></i>
                <i class="fab fa-github fa-2x"></i>
            </div>
        </div>
        
        <div class="test-section">
            <h2>Google Font Test</h2>
            <p>This text should be in Roboto font if Google Fonts is loading correctly.</p>
            <p style="font-weight: 700;">This should be bold Roboto.</p>
        </div>
        
        <div class="test-section">
            <h2>Bootstrap Components Test</h2>
            <button class="btn btn-primary">Primary Button</button>
            <button class="btn btn-success">Success Button</button>
            <div class="alert alert-info mt-3">
                This is a Bootstrap alert
            </div>
        </div>
        
        <div class="test-section">
            <h2>jQuery Test</h2>
            <p id="jquery-test">jQuery status: Checking...</p>
        </div>
        
        <div class="test-section">
            <h2>CloudFlare CDN Test</h2>
            <p id="cloudflare-test">CloudFlare script status: Checking...</p>
        </div>
    </div>
    
    <!-- Test Script Loading -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/2.10.2/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.min.js"></script>
    
    <script>
        // Test jQuery
        $(document).ready(function() {
            $('#jquery-test').html('jQuery status: <span class="success">Working!</span>');
            
            // Test CloudFlare script
            setTimeout(function() {
                if (typeof bootstrap !== 'undefined') {
                    $('#cloudflare-test').html('CloudFlare script status: <span class="success">Working!</span>');
                } else {
                    $('#cloudflare-test').html('CloudFlare script status: <span class="failure">Failed!</span>');
                }
            }, 1000);
        });
        
        // Listen for CSP violations
        document.addEventListener('securitypolicyviolation', function(e) {
            console.error('CSP violation detected:', e.blockedURI, e.violatedDirective);
            
            // Add to page
            var violationDiv = document.createElement('div');
            violationDiv.className = 'test-section';
            violationDiv.innerHTML = '<h3 class="failure">CSP Violation Detected</h3>' +
                '<p><strong>Blocked URI:</strong> ' + e.blockedURI + '</p>' +
                '<p><strong>Violated Directive:</strong> ' + e.violatedDirective + '</p>';
            
            document.querySelector('.container').appendChild(violationDiv);
        });
    </script>
</body>
</html> 