<?php $m4='active';

include 'config.php';

$pageArray=array('Category'=>'TibcoToMuleSoft');

$PageData=$classConn->fetchsingleDESC('per_pages',$pageArray,'id');


// Meta Tag Imformation

$PageData['primary_Meta_title'] = 'Tibco To MuleSoft | Caelius Consulting';
$PageData['primary_Meta_description'] = 'Connect and Learn With Us';


$PorfolioArray=array('page_category'=>'Porfolio');
$PorfolioData=$classConn->fetchalln('per_pages',$PorfolioArray);


include('header.php'); ?>

<!-- Start of HubSpot Embed Code -->
<script type="text/javascript" id="hs-script-loader" async defer src="//js-na1.hs-scripts.com/22253134.js"></script>
<!-- End of HubSpot Embed Code -->

<!-- <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.css"> -->

<section class="virtual_meet t2m">
	<section class="hero">
		<div class="container">
			<div class="row">
				<div class="col-md-7">
					<h1>
						Caelius’
						<br>
						<span>TIBCO To MuleSoft</span>
						<br>
						Migration Accelerator
					</h1>
				</div>
			</div>
		</div>
	</section>

	<section class="hero_line">
		<div class="container">
			<div class="row justify-content-center">
				<div class="col-md-10 text-center">
					<h3>The T2M accelerator, a powerful solution tailor-made for customers and enterprises transitioning from traditional TIBCO integration solution  to modern API-based MuleSoft integration systems.</h3>
				</div>
			</div>
		</div>
	</section>

	<section class="video pb-5 mb-5">
		<div class="container">
			<div class="row justify-content-center">
				<div class="col-md-10 text-center">
					<div class="video--outer">
						<video width="100%" preload="auto" loop="loop" muted autoplay controls>
							<source src="<?php echo $base_url; ?>image/t2m-video.webm" type="video/webm">
						</video>
					</div>
				</div>
			</div>
		</div>
	</section>

	<section class="features">
		<div class="container">
			<div class="row">
				<div class="col-md-3 p-0">
					<div class="card">
						<img src="<?php echo $base_url; ?>image/icons/publication_api.svg">
						<h3>Automated migration and publication of API Specifications</h3>
						<p>Translates a TIBCO project input into API Specifications by processing an EAR file.</p>
					</div>
				</div>
				<div class="col-md-3 p-0">
					<div class="card gradient" style="background: #D9D9D9;">
						<img src="<?php echo $base_url; ?>image/icons/muleflows.svg">
						<h3>Automated MuleFlows </h3>
						<p>Intuitively crafts necessary Mule flows, leveraging the methods and endpoints.</p>
					</div>
				</div>
				<div class="col-md-3 p-0">
					<div class="card" style="background: #E6E6E6;">
						<img src="<?php echo $base_url; ?>image/icons/archetypes.svg">
						<h3>Automated use of artifacts and ArcheTypes for migrated APIs</h3>
						<p>Sets up a project  in Anypoint Design Center and publishes it to Anypoint Exchange.</p>
					</div>
				</div>
				<div class="col-md-3 p-0">
					<div class="card gradient" style="background: #F2F2F2;">
						<img src="<?php echo $base_url; ?>image/icons/migration.svg">
						<h3>Upto 50% reduction in migration effort</h3>
						<p>Massive savings in cost and far less time to market with T2M Accelerator.</p>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-12">
					<div class="actions d-flex justify-content-center py-5 flex-wrap">
						<a href="https://www.youtube.com/watch?v=utu_V0wgm_U&t=820s" target="_blank" class="theme-btn-outline secondary"><img class="mr-2" src="<?php echo $base_url; ?>image/icons/view.svg">Watch live demo</a>
						<a href="/contact_us" class="theme-btn-outline"><img class="mr-2" src="<?php echo $base_url; ?>image/icons/calendar.svg">Let's talk</a>
					</div>
				</div>
			</div>
		</div>
	</section>
</section>


<!-- Testimonaial Section Start -->

<section class="testimonial" style="margin-bottom: 90px;">
	<div class="container-fluid p-0">
	<h3 class="heading text-center mb-5">Customer <span>Reviews</span></h3>
		<div class="quote-mark text-center">
			<img src="<?php echo $base_url; ?>image/homepage/quotation.svg" alt="Quotation Mark" class="img-fluid m-auto" width="100" height="100">
		</div>
		<div class="slider owl-carousel">

			<!-- TGI Fridays -->

			<div class="item">
				<p>Having worked with several outsourcing companies, Caelius is the by far the best. Instead of needing specific direction on every task, they have taken ownership of our Mulesoft and Database environments. Caelius is a part of Fridays team and family, not just a resource to reach out. They have made my life easier!!!<span class="invisible">They have made my life easier!!!</span></p>
				<div class="client-detail">
					<h5>David Gibson</h5>
					<h6>Sr. Director Information Technology</h6>
					<img src="<?php echo $base_url; ?>image/homepage/testimonials/tgi-fridays.png" alt="TGI Fridays" class="img-fluid" width="150" height="70">
				</div>
			</div>

			<!-- Burns Mcdonnell -->

			<div class="item">
				<p>Caelius provides us with critical insight into our best practices on the MuleSoft Anypoint Platform so that we can deliver reusable APIs quickly without sacrificing quality. The technical guidance provided by Caelius will be the cornerstones of our future integration initiatives for Burns & McDonnell. The consulting service is outstanding.</p>
				<div class="client-detail">
					<h5>Shuai Wang</h5>
					<h6>Integration Manager - Burns & McDonnell.</h6>
					<img src="<?php echo $base_url; ?>image/homepage/testimonials/burns-mcdonnell.png" alt="TGI Fridays" class="img-fluid" width="150" height="70">
				</div>
			</div>

			<!-- CBU (West) -->

			<div class="item">
				<p>Working with Caelius was super easy. I reached out during the Holiday season about Radiant Logistics. Explained the red account and renewal challenges to them. Caelius was quick to respond and met with the client right away. They coordinated an onsite client visit and got started right away. Fast forward three months, we have the renewal and great product adoption.</p>
				<div class="client-detail">
					<h5>Trevor Floyd</h5>
					<h6>Account Executive - CBU (West).</h6>
					<img src="<?php echo $base_url; ?>image/homepage/testimonials/radiant_logistics.png" alt="TGI Fridays" class="img-fluid" width="150" height="70">
				</div>
			</div>

			<!-- IHG -->

			<div class="item">
				<p>IHG wanted a MuleSoft partner with the domain expertise to address critical business initiatives. I was aware of Caelius' reliable and extensive work with Mule PS across multiple domains and hospitality, one among them. Their success with IHG over the last year has resulted in increased ACV and has made us sticky for years to come. They are my go-to partner today!!</p>
				<div class="client-detail">
					<h5>Shawn Turschak</h5>
					<h6>Enterprise Account Executive - Hospitality.</h6>
					<img src="<?php echo $base_url; ?>image/homepage/testimonials/IHG.png" alt="TGI Fridays" class="img-fluid" width="150" height="70">
				</div>
			</div>
							
		</div>
	</div>
</section>


<!-- Testimonaial Section End -->


<!-- Modal -->
<div class="modal fade" id="calendarBookingModal" data-backdrop="static" tabindex="-1" aria-labelledby="calendarBookingModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content p-3 d-flex align-items-center">
      <iframe src="https://meetings.hubspot.com/harjot-sekhon?embed=true" style="width: 100%; aspect-ratio: auto; height: 620px;" frameborder="0"></iframe>
    </div>
  </div>
</div>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.1/jquery.min.js"></script>
<script type="text/javascript" src="https://static.hsappstatic.net/MeetingsEmbed/ex/MeetingsEmbedCode.js"></script>
<!-- <script>
 $(document).ready(function(){
    $("#Create2").hide();

	$("#btn").click(function () {
		$("#Create2").toggle();
	// $("#Create").hide();
	$(".book_call_form").addClass("d-none");
	});
	$("#reset_btn").click(function () {
		window.location.reload();
    });
});
</script> -->
<?php include('footer.php'); ?>

