<?php
// Enable error display
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Show PHP version and info
echo "PHP Version: " . phpversion() . "<br>";
echo "Extensions loaded: <pre>" . print_r(get_loaded_extensions(), true) . "</pre><br>";

// Test basic filesystem functions
echo "Current directory: " . __DIR__ . "<br>";
echo "File exists (security.php): " . (file_exists(__DIR__ . "/security.php") ? "Yes" : "No") . "<br>";
echo "File exists (config.php): " . (file_exists(__DIR__ . "/config.php") ? "Yes" : "No") . "<br>";
echo "File exists (header.php): " . (file_exists(__DIR__ . "/header.php") ? "Yes" : "No") . "<br>";
echo "File exists (footer.php): " . (file_exists(__DIR__ . "/footer.php") ? "Yes" : "No") . "<br>";
echo "File exists (xss-protection.php): " . (file_exists(__DIR__ . "/xss-protection.php") ? "Yes" : "No") . "<br>";
echo "File exists (sri-implementation.php): " . (file_exists(__DIR__ . "/sri-implementation.php") ? "Yes" : "No") . "<br>";

// Try to include essential files one by one to see where it breaks
echo "<h3>Testing includes:</h3>";

try {
    echo "Testing include of config.php... ";
    include_once 'config.php';
    echo "SUCCESS<br>";
} catch (Throwable $e) {
    echo "FAILED: " . $e->getMessage() . "<br>";
}

try {
    echo "Testing include of security.php... ";
    include_once 'security.php';
    echo "SUCCESS<br>";
} catch (Throwable $e) {
    echo "FAILED: " . $e->getMessage() . "<br>";
}

// Check if basic functions exist
echo "<h3>Testing functions:</h3>";
echo "Function exists (sanitizeOutput): " . (function_exists('sanitizeOutput') ? "Yes" : "No") . "<br>";
echo "Function exists (escape_output): " . (function_exists('escape_output') ? "Yes" : "No") . "<br>";
echo "Function exists (sanitize_url): " . (function_exists('sanitize_url') ? "Yes" : "No") . "<br>";
echo "Function exists (csrfTokenField): " . (function_exists('csrfTokenField') ? "Yes" : "No") . "<br>";
echo "Function exists (sriScriptTag): " . (function_exists('sriScriptTag') ? "Yes" : "No") . "<br>";

// Test database connection
if (isset($db)) {
    echo "<h3>Database connection:</h3>";
    try {
        $result = $db->query("SELECT 1");
        echo "Database connection is working.<br>";
    } catch (Throwable $e) {
        echo "Database error: " . $e->getMessage() . "<br>";
    }
} else {
    echo "Database variable \$db not set.<br>";
}

// Get server environment
echo "<h3>Server environment:</h3>";
echo "Server software: " . $_SERVER['SERVER_SOFTWARE'] . "<br>";
echo "Document root: " . $_SERVER['DOCUMENT_ROOT'] . "<br>";

// Check error log
echo "<h3>Last 10 lines of error log:</h3>";
$errorLog = ini_get('error_log');
if (file_exists($errorLog) && is_readable($errorLog)) {
    $logContent = file($errorLog);
    $last10 = array_slice($logContent, -10);
    echo "<pre>" . implode("", $last10) . "</pre>";
} else {
    echo "Error log not found or not readable: $errorLog<br>";
    
    // Alternative check for error_log in current directory
    if (file_exists(__DIR__ . "/error_log") && is_readable(__DIR__ . "/error_log")) {
        $logContent = file(__DIR__ . "/error_log");
        $last10 = array_slice($logContent, -10);
        echo "<pre>" . implode("", $last10) . "</pre>";
    } else {
        echo "No error_log found in current directory either.<br>";
    }
}
?> 