<?php
// Secure password for viewing debug logs
define('DEBUG_VIEWER_PASSWORD', 'CaeliusDebug');

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if authenticated or attempting to authenticate
$authenticated = false;
$error = '';

if (isset($_POST['password']) && $_POST['password'] === DEBUG_VIEWER_PASSWORD) {
    $_SESSION['debug_authenticated'] = true;
    $authenticated = true;
} elseif (isset($_POST['password'])) {
    $error = 'Invalid password';
} elseif (isset($_SESSION['debug_authenticated']) && $_SESSION['debug_authenticated'] === true) {
    $authenticated = true;
}

// Log out if requested
if (isset($_GET['logout'])) {
    unset($_SESSION['debug_authenticated']);
    $authenticated = false;
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}

// Function to get all debug log files
function getDebugLogs() {
    $logs = [];
    
    // Check main debug directory
    if (is_dir('debug')) {
        $files = glob('debug/*.log');
        $logs = array_merge($logs, $files);
    }
    
    // Check logs directory
    if (is_dir('logs')) {
        $files = glob('logs/*.log');
        $logs = array_merge($logs, $files);
    }
    
    // Check for specific files in root
    $rootLogs = ['form-debug.log', 'debug.log', 'error_log'];
    foreach ($rootLogs as $log) {
        if (file_exists($log)) {
            $logs[] = $log;
        }
    }
    
    return $logs;
}

// Clear a log file if requested
if ($authenticated && isset($_GET['clear']) && !empty($_GET['clear'])) {
    $logFile = $_GET['clear'];
    
    // Basic security check to prevent directory traversal
    if (strpos($logFile, '..') === false && file_exists($logFile)) {
        file_put_contents($logFile, '');
        header('Location: ' . $_SERVER['PHP_SELF'] . '?file=' . urlencode($logFile) . '&cleared=1');
        exit;
    }
}

// Create debug directory and test log file if they don't exist
if (!is_dir('debug')) {
    mkdir('debug', 0755, true);
}

// Create a test log entry if requested
if ($authenticated && isset($_GET['test'])) {
    $logFile = 'debug/career_form.log';
    $timestamp = date('Y-m-d H:i:s');
    $testMessage = "[$timestamp] Test log entry created via debug viewer\n";
    file_put_contents($logFile, $testMessage, FILE_APPEND);
    header('Location: ' . $_SERVER['PHP_SELF'] . '?file=' . urlencode($logFile) . '&tested=1');
    exit;
}

// Get log content if authenticated and file is specified
$logContent = '';
$currentFile = '';
if ($authenticated && isset($_GET['file']) && !empty($_GET['file'])) {
    $logFile = $_GET['file'];
    
    // Basic security check to prevent directory traversal
    if (strpos($logFile, '..') === false && file_exists($logFile)) {
        $logContent = file_get_contents($logFile);
        $currentFile = $logFile;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Career Form Debug Viewer</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            margin: 0;
            padding: 20px;
            color: #333;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
        }
        h1 {
            color: #444;
            border-bottom: 1px solid #ddd;
            padding-bottom: 10px;
        }
        .login-form {
            max-width: 400px;
            margin: 100px auto;
            padding: 20px;
            border: 1px solid #ddd;
            border-radius: 4px;
            background-color: #f9f9f9;
        }
        .error {
            color: red;
            margin-bottom: 10px;
        }
        .success {
            color: green;
            margin-bottom: 10px;
        }
        input[type="password"] {
            width: 100%;
            padding: 8px;
            margin-bottom: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
        }
        button, .button {
            background-color: #4CAF50;
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            margin-right: 10px;
        }
        button:hover, .button:hover {
            background-color: #45a049;
        }
        .logout {
            float: right;
            background-color: #f44336;
        }
        .logout:hover {
            background-color: #d32f2f;
        }
        .test-button {
            background-color: #2196F3;
        }
        .test-button:hover {
            background-color: #0b7dda;
        }
        .log-list {
            width: 20%;
            float: left;
            margin-right: 2%;
        }
        .log-content {
            width: 78%;
            float: left;
        }
        .log-list ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        .log-list li {
            margin-bottom: 5px;
        }
        .log-list a {
            display: block;
            padding: 8px;
            background-color: #f1f1f1;
            color: #333;
            text-decoration: none;
            border-radius: 4px;
        }
        .log-list a:hover, .log-list a.active {
            background-color: #ddd;
        }
        pre {
            background-color: #f5f5f5;
            padding: 15px;
            border-radius: 4px;
            overflow: auto;
            white-space: pre-wrap;
            word-wrap: break-word;
            height: 600px;
            overflow-y: scroll;
        }
        .actions {
            margin-bottom: 10px;
        }
        .clear-log {
            background-color: #ff9800;
            color: white;
        }
        .clear-log:hover {
            background-color: #e68a00;
        }
        .clearfix::after {
            content: "";
            clear: both;
            display: table;
        }
    </style>
</head>
<body>
    <div class="container">
        <?php if (!$authenticated): ?>
            <div class="login-form">
                <h2>Career Form Debug Viewer</h2>
                <?php if ($error): ?>
                    <div class="error"><?php echo $error; ?></div>
                <?php endif; ?>
                <form method="post">
                    <div>
                        <input type="password" name="password" placeholder="Password" required>
                    </div>
                    <button type="submit">Login</button>
                </form>
            </div>
        <?php else: ?>
            <h1>
                Career Form Debug Viewer
                <a href="?logout=1" class="logout">Logout</a>
            </h1>
            
            <?php if (isset($_GET['cleared']) && $_GET['cleared'] == 1): ?>
                <div class="success">Log file has been cleared.</div>
            <?php endif; ?>
            
            <?php if (isset($_GET['tested']) && $_GET['tested'] == 1): ?>
                <div class="success">Test log entry created.</div>
            <?php endif; ?>
            
            <div class="actions">
                <a href="?test=1" class="button test-button">Create Test Log Entry</a>
                <a href="debug-career-form.php" class="button">Run Diagnostic Tool</a>
            </div>
            
            <div class="clearfix">
                <div class="log-list">
                    <h2>Debug Log Files</h2>
                    <ul>
                        <?php foreach (getDebugLogs() as $logFile): ?>
                            <li>
                                <a href="?file=<?php echo urlencode($logFile); ?>" 
                                   class="<?php echo ($currentFile === $logFile) ? 'active' : ''; ?>">
                                    <?php echo basename($logFile); ?>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                
                <div class="log-content">
                    <?php if ($currentFile): ?>
                        <h2><?php echo basename($currentFile); ?></h2>
                        
                        <div class="actions">
                            <a href="?clear=<?php echo urlencode($currentFile); ?>" 
                               class="button clear-log" 
                               onclick="return confirm('Are you sure you want to clear this log file?');">
                                Clear Log
                            </a>
                        </div>
                        
                        <pre><?php echo htmlspecialchars($logContent); ?></pre>
                    <?php else: ?>
                        <p>Please select a log file from the list to view its contents.</p>
                        
                        <h3>Debugging Instructions</h3>
                        <ol>
                            <li>Click "Create Test Log Entry" to verify logging is working.</li>
                            <li>Try submitting the career form again.</li>
                            <li>Check the "career_form.log" file for detailed information about what's happening.</li>
                            <li>Run the diagnostic tool to see database connection status and form field mappings.</li>
                        </ol>
                        
                        <h3>Common Issues</h3>
                        <ul>
                            <li>Field name mismatches between form and processing script</li>
                            <li>Database connection problems</li>
                            <li>File upload permission issues</li>
                            <li>JavaScript errors preventing form submission</li>
                        </ul>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
</body>
</html> 