<?php
// Define a basic authentication password
define('LOG_VIEWER_PASSWORD', 'CaeliusSecureAccess');

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if authenticated or attempting to authenticate
$authenticated = false;
$error = '';

if (isset($_POST['password']) && $_POST['password'] === LOG_VIEWER_PASSWORD) {
    $_SESSION['log_authenticated'] = true;
    $authenticated = true;
} elseif (isset($_POST['password'])) {
    $error = 'Invalid password';
} elseif (isset($_SESSION['log_authenticated']) && $_SESSION['log_authenticated'] === true) {
    $authenticated = true;
}

// Log out if requested
if (isset($_GET['logout'])) {
    unset($_SESSION['log_authenticated']);
    $authenticated = false;
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}

// Function to get all log files
function getLogFiles() {
    $logs = [];
    $logDirs = ['logs', 'log'];
    
    foreach ($logDirs as $dir) {
        if (is_dir($dir)) {
            $files = glob($dir . '/*.log');
            $logs = array_merge($logs, $files);
        }
    }
    
    // Check for form-debug.log in root
    if (file_exists('form-debug.log')) {
        $logs[] = 'form-debug.log';
    }
    
    return $logs;
}

// Clear a log file if requested
if ($authenticated && isset($_GET['clear']) && !empty($_GET['clear'])) {
    $logFile = $_GET['clear'];
    
    // Basic security check to prevent directory traversal
    if (strpos($logFile, '..') === false && file_exists($logFile)) {
        file_put_contents($logFile, '');
        header('Location: ' . $_SERVER['PHP_SELF'] . '?file=' . urlencode($logFile) . '&cleared=1');
        exit;
    }
}

// Get log content if authenticated and file is specified
$logContent = '';
$currentFile = '';
if ($authenticated && isset($_GET['file']) && !empty($_GET['file'])) {
    $logFile = $_GET['file'];
    
    // Basic security check to prevent directory traversal
    if (strpos($logFile, '..') === false && file_exists($logFile)) {
        $logContent = file_get_contents($logFile);
        $currentFile = $logFile;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Log Viewer</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            margin: 0;
            padding: 20px;
            color: #333;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
        }
        h1 {
            color: #444;
            border-bottom: 1px solid #ddd;
            padding-bottom: 10px;
        }
        .login-form {
            max-width: 400px;
            margin: 100px auto;
            padding: 20px;
            border: 1px solid #ddd;
            border-radius: 4px;
            background-color: #f9f9f9;
        }
        .error {
            color: red;
            margin-bottom: 10px;
        }
        .success {
            color: green;
            margin-bottom: 10px;
        }
        input[type="password"] {
            width: 100%;
            padding: 8px;
            margin-bottom: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
        }
        button {
            background-color: #4CAF50;
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        button:hover {
            background-color: #45a049;
        }
        .logout {
            float: right;
            background-color: #f44336;
        }
        .logout:hover {
            background-color: #d32f2f;
        }
        .log-list {
            width: 20%;
            float: left;
            margin-right: 2%;
        }
        .log-content {
            width: 78%;
            float: left;
        }
        .log-list ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        .log-list li {
            margin-bottom: 5px;
        }
        .log-list a {
            display: block;
            padding: 8px;
            background-color: #f1f1f1;
            color: #333;
            text-decoration: none;
            border-radius: 4px;
        }
        .log-list a:hover, .log-list a.active {
            background-color: #ddd;
        }
        pre {
            background-color: #f5f5f5;
            padding: 15px;
            border-radius: 4px;
            overflow: auto;
            white-space: pre-wrap;
            word-wrap: break-word;
            height: 600px;
            overflow-y: scroll;
        }
        .actions {
            margin-bottom: 10px;
        }
        .clear-log {
            background-color: #ff9800;
            color: white;
        }
        .clear-log:hover {
            background-color: #e68a00;
        }
        .clearfix::after {
            content: "";
            clear: both;
            display: table;
        }
    </style>
</head>
<body>
    <div class="container">
        <?php if (!$authenticated): ?>
            <div class="login-form">
                <h2>Log Viewer Authentication</h2>
                <?php if ($error): ?>
                    <div class="error"><?php echo $error; ?></div>
                <?php endif; ?>
                <form method="post">
                    <div>
                        <input type="password" name="password" placeholder="Password" required>
                    </div>
                    <button type="submit">Login</button>
                </form>
            </div>
        <?php else: ?>
            <h1>
                Log Viewer
                <a href="?logout=1" class="logout">Logout</a>
            </h1>
            
            <?php if (isset($_GET['cleared']) && $_GET['cleared'] == 1): ?>
                <div class="success">Log file has been cleared.</div>
            <?php endif; ?>
            
            <div class="clearfix">
                <div class="log-list">
                    <h2>Log Files</h2>
                    <ul>
                        <?php foreach (getLogFiles() as $logFile): ?>
                            <li>
                                <a href="?file=<?php echo urlencode($logFile); ?>" 
                                   class="<?php echo ($currentFile === $logFile) ? 'active' : ''; ?>">
                                    <?php echo basename($logFile); ?>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                
                <div class="log-content">
                    <?php if ($currentFile): ?>
                        <h2><?php echo basename($currentFile); ?></h2>
                        
                        <div class="actions">
                            <a href="?clear=<?php echo urlencode($currentFile); ?>" 
                               class="clear-log" 
                               onclick="return confirm('Are you sure you want to clear this log file?');">
                                Clear Log
                            </a>
                        </div>
                        
                        <pre><?php echo htmlspecialchars($logContent); ?></pre>
                    <?php else: ?>
                        <p>Please select a log file from the list to view its contents.</p>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
</body>
</html> 